/*
 * Decompiled with CFR 0.152.
 */
package net.yggdraszil.edexpandere.block.mechanicalhammers;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraftforge.network.PacketDistributor;
import net.yggdraszil.edexpandere.block.ModBlockEntities;
import net.yggdraszil.edexpandere.block.mechanicalhammers.CreativeMechanicalHammerBlock;
import net.yggdraszil.edexpandere.config.ExpandereConfig;
import net.yggdraszil.edexpandere.menu.mechanicalhammers.CreativeMechanicalHammerMenu;
import net.yggdraszil.edexpandere.networking.ModMessages;
import net.yggdraszil.edexpandere.networking.packet.HammerDataSyncPacket;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.exdeorum.blockentity.AbstractMachineBlockEntity;
import thedarkcolour.exdeorum.blockentity.helper.EnergyHelper;
import thedarkcolour.exdeorum.blockentity.helper.ItemHelper;
import thedarkcolour.exdeorum.loot.HammerLootModifier;
import thedarkcolour.exdeorum.recipe.RecipeUtil;
import thedarkcolour.exdeorum.recipe.hammer.HammerRecipe;
import thedarkcolour.exdeorum.tag.EItemTags;

public class CreativeMechanicalHammerBlockEntity
extends AbstractMachineBlockEntity<CreativeMechanicalHammerBlockEntity>
implements MenuProvider {
    public static final int TOTAL_PROGRESS = 10000000;
    private static final int BASE_PROGRESS_INTERVAL = 50000;
    private static final int NOT_RUNNING = -1;
    private int progress = -1;
    private float efficiency = 1.0f;
    private final EnergyHelper energyHelper = new EnergyHelper(ExpandereConfig.creative_mechanical_hammer_energyStorage);

    public CreativeMechanicalHammerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.CREATIVE_MECHANICAL_HAMMER.get(), pos, state, CreativeMechanicalHammerBlockEntity::createInventory, ExpandereConfig.creative_mechanical_hammer_energyStorage);
    }

    private static ItemHelper createInventory(final CreativeMechanicalHammerBlockEntity entity) {
        return new ItemHelper(3){

            public boolean isItemValid(int slot, ItemStack stack) {
                if (slot == 0) {
                    return RecipeUtil.getHammerRecipe((Item)stack.m_41720_()) != null;
                }
                if (slot == 1) {
                    return stack.m_204117_(EItemTags.HAMMERS);
                }
                return false;
            }

            public int getSlotLimit(int slot) {
                return slot == 1 ? 1 : super.getSlotLimit(slot);
            }

            public boolean canMachineExtract(int slot) {
                return slot == 2;
            }

            protected void onContentsChanged(int slot) {
                if (slot == 1) {
                    entity.onHammerChanged();
                } else if (slot == 0 && this.getStackInSlot(0).m_41619_()) {
                    entity.progress = -1;
                    entity.setRunning(false);
                }
            }
        };
    }

    protected int getEnergyConsumption() {
        return ExpandereConfig.creative_mechanical_hammer_energyConsumption;
    }

    private float calculateEfficiency() {
        return this.efficiency + 0.1f * (float)ExpandereConfig.creative_mechanical_hammer_speed;
    }

    protected void runMachineTick() {
        ItemStack input = this.inventory.getStackInSlot(0);
        if (!input.m_41619_()) {
            HammerRecipe recipe = this.canFitResultIntoOutput(input);
            if (recipe != null) {
                float efficiencyMultiplier = this.calculateEfficiency();
                int progressIncrement = (int)(50000.0f * efficiencyMultiplier);
                this.progress += progressIncrement;
                if (this.progress >= 10000000) {
                    LootContext ctx = RecipeUtil.emptyLootContext((ServerLevel)((ServerLevel)this.f_58857_));
                    int resultCount = recipe.resultAmount.m_142683_(ctx);
                    resultCount += HammerLootModifier.calculateFortuneBonus((ItemStack)this.inventory.getStackInSlot(1), (RandomSource)ctx.m_230907_(), (resultCount == 0 ? 1 : 0) != 0);
                    ItemStack output = this.inventory.getStackInSlot(2);
                    if (output.m_41619_()) {
                        ItemStack stack = new ItemStack((ItemLike)recipe.result, resultCount);
                        stack.m_41751_(recipe.getResultNbt());
                        this.inventory.setStackInSlot(2, stack);
                    } else {
                        output.m_41764_(Math.min(output.m_41741_(), resultCount + output.m_41613_()));
                    }
                    input.m_41774_(1);
                    this.damageHammer(ctx.m_230907_());
                    this.m_6596_();
                    this.progress = 0;
                }
                this.setRunning(true);
            } else {
                this.progress = -1;
                this.setRunning(false);
            }
        } else {
            this.setRunning(false);
        }
        ModMessages.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new HammerDataSyncPacket(this.getEnergyStored(), this.getProgress(), this.f_58858_));
    }

    private HammerRecipe canFitResultIntoOutput(ItemStack input) {
        HammerRecipe recipe;
        ItemStack output = this.inventory.getStackInSlot(2);
        if ((output.m_41619_() || output.m_41613_() < output.m_41741_()) && (recipe = RecipeUtil.getHammerRecipe((Item)input.m_41720_())) != null && (output.m_41619_() || CreativeMechanicalHammerBlockEntity.matchesStack(recipe.result, recipe.getRawResultNbt(), output))) {
            return recipe;
        }
        return null;
    }

    private static boolean matchesStack(Item item, @Nullable CompoundTag itemNbt, ItemStack stack) {
        return Objects.equals(itemNbt, stack.m_41783_()) && item == stack.m_41720_();
    }

    private void damageHammer(RandomSource rand) {
        ItemStack hammer = this.inventory.getStackInSlot(1);
        if (hammer.m_41763_() && hammer.m_220157_(1, rand, null)) {
            hammer.m_41774_(1);
            if (hammer.m_41619_()) {
                this.inventory.setStackInSlot(1, ItemStack.f_41583_);
            }
        }
    }

    private boolean hasEnergy() {
        return this.getEnergyStored() >= this.getEnergyConsumption();
    }

    private boolean hasValidInput() {
        ItemStack input = this.inventory.getStackInSlot(0);
        return RecipeUtil.getHammerRecipe((Item)input.m_41720_()) != null && !input.m_41619_();
    }

    private void consumeEnergy() {
        this.energy.extractEnergy(this.getEnergyConsumption(), false);
    }

    private void onHammerChanged() {
        ItemStack hammer = this.inventory.getStackInSlot(1);
        this.efficiency = hammer.m_41619_() ? 1.0f : 2.0f + (float)hammer.getEnchantmentLevel(Enchantments.f_44984_) * 0.33f;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, CreativeMechanicalHammerBlockEntity entity) {
        if (level != null && !level.f_46443_) {
            if (entity.redstoneMode == 0 || entity.redstoneMode == 1 != entity.hasRedstonePower) {
                if (entity.hasEnergy() && entity.hasValidInput()) {
                    entity.consumeEnergy();
                    entity.runMachineTick();
                } else {
                    entity.noEnergyTick();
                }
            }
            ModMessages.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new HammerDataSyncPacket(entity.getEnergyStored(), entity.getProgress(), entity.f_58858_));
        }
    }

    public EnergyHelper getEnergyHelper() {
        return this.energyHelper;
    }

    protected void noEnergyTick() {
        this.setRunning(false);
    }

    protected boolean isRunning() {
        return this.progress != -1;
    }

    protected void tryStartRunning() {
        this.setRunning(true);
    }

    private void setRunning(boolean running) {
        this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)CreativeMechanicalHammerBlock.RUNNING, (Comparable)Boolean.valueOf(running)), 3);
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public int getEnergyStored() {
        return this.energy.getEnergyStored();
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.edexpandere.creative_mechanical_hammer");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, @NotNull Inventory playerInventory, @NotNull Player player) {
        return new CreativeMechanicalHammerMenu(id, playerInventory, this);
    }

    public static boolean isValidInput(ItemStack stack) {
        return RecipeUtil.getHammerRecipe((Item)stack.m_41720_()) != null;
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.inventory.getSlots());
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            inventory.m_6836_(i, this.inventory.getStackInSlot(i));
        }
        assert (this.f_58857_ != null);
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }
}

